
#ifndef WN_H




/* Data structures used by search code functions. */

/* Structure for index file entry */
typedef struct {
    long idxoffset;		/* byte offset of entry in index file */
    char *wd;			/* word string */
    char *pos;			/* part of speech */
    int sense_cnt;		/* sense (collins) count */
    int off_cnt;		/* number of offsets */
    int tagged_cnt;		/* number senses that are tagged */
    unsigned long *offset;	/* offsets of synsets containing word */
    int ptruse_cnt;		/* number of pointers used */
    int *ptruse;		/* pointers used */
} Index;


typedef Index *IndexPtr;

extern IndexPtr parse_index(long, int, char *);

//extern char *ptrtyp[];		/* pointer characters */

/* Return pointer code for pointer type characer passed. */
extern int getptrtype(char *);	
extern char *num_to_str(int);

/* Pointer type and search type counts */

/* Pointers */

#define ANTPTR           1	/* ! */
#define HYPERPTR         2	/* @ */
#define HYPOPTR          3	/* ~ */
#define ENTAILPTR        4	/* * */
#define SIMPTR           5	/* & */

#define ISMEMBERPTR      6	/* #m */
#define ISSTUFFPTR       7	/* #s */
#define ISPARTPTR        8	/* #p */

#define HASMEMBERPTR     9	/* %m */
#define HASSTUFFPTR     10	/* %s */
#define HASPARTPTR      11	/* %p */

#define MERONYM         12	/* % (not valid in lexicographer file) */
#define HOLONYM         13	/* # (not valid in lexicographer file) */
#define CAUSETO         14	/* > */
#define PPLPTR	        15	/* < */
#define SEEALSOPTR      16	/* ^ */
#define PERTPTR         17	/* \ */
#define ATTRIBUTE       18	/* = */
#define VERBGROUP       19	/* $ */
#define DERIVATION      20	/* + */
#define CLASSIFICATION  21	/* ; */
#define CLASS           22	/* - */

#define LASTTYPE	CLASS

#define OVERVIEW	(LASTTYPE + 9)

#define MAXSEARCH       OVERVIEW

#define CLASSIF_START    (MAXSEARCH + 1)

#define CLASSIF_CATEGORY (CLASSIF_START)        /* ;c */
#define CLASSIF_USAGE    (CLASSIF_START + 1)    /* ;u */
#define CLASSIF_REGIONAL (CLASSIF_START + 2)    /* ;r */

#define CLASSIF_END      CLASSIF_REGIONAL

#define CLASS_START      (CLASSIF_END + 1)
#define CLASS_CATEGORY   (CLASS_START)          /* -c */
#define CLASS_USAGE      (CLASS_START + 1)      /* -u */
#define CLASS_REGIONAL   (CLASS_START + 2)      /* -r */

#define CLASS_END        CLASS_REGIONAL

#define INSTANCE         (CLASS_END + 1)        /* @i */
#define INSTANCES        (CLASS_END + 2)        /* ~i */

#define MAXPTR          INSTANCES





char *ptrtyp[]={
    "",				/* 0 not used */
    "!",			/* 1 ANTPTR */
    "@",			/* 2 HYPERPTR */
    "~",			/* 3 HYPOPTR */
    "*",			/* 4 ENTAILPTR */
    "&",			/* 5 SIMPTR */
    "#m",			/* 6 ISMEMBERPTR */
    "#s",			/* 7 ISSTUFFPTR */
    "#p",			/* 8 ISPARTPTR */
    "%m",			/* 9 HASMEMBERPTR */
    "%s",			/* 10 HASSTUFFPTR */
    "%p",			/* 11 HASPARTPTR */
    "%",			/* 12 MERONYM */
    "#",			/* 13 HOLONYM */
    ">",			/* 14 CAUSETO */
    "<",			/* 15 PPLPTR */
    "^",			/* 16 SEEALSO */
    "\\",			/* 17 PERTPTR */
    "=",			/* 18 ATTRIBUTE */
    "$",			/* 19 VERBGROUP */
    "+",		        /* 20 NOMINALIZATIONS */
    ";",			/* 21 CLASSIFICATION */
    "-",			/* 22 CLASS */
/* additional searches, but not pointers.  */
    "",				/* SYNS */
    "",				/* FREQ */
    "+",			/* FRAMES */
    "",				/* COORDS */
    "",				/* RELATIVES */
    "",				/* HMERONYM */
    "",				/* HHOLONYM */
    "",				/* WNGREP */
    "",				/* OVERVIEW */
    ";c",			/* CLASSIF_CATEGORY */
    ";u",			/* CLASSIF_USAGE */
    ";r",			/* CLASSIF_REGIONAL */
    "-c",			/* CLASS_CATEGORY */
    "-u",			/* CLASS_USAGE */
    "-r",			/* CLASS_REGIONAL */
    "@i",			/* INSTANCE */
    "~i",			/* INSTANCES */
    NULL,
};  













#endif